# For Each Reel, we need the following details:

* positive/negative content
* is appropriate

* is awareness
* is grounding
* ❌is purposeful
* is mindfulness (is awareness, is grounding, journalism)

# Awareness Exercises:

* (`mindful-breathing`) Mindful breathing - focus on the sensation of your breadth, inhale and exhale slowly, returning focus when distracted
* (`noticing-sound`) Noticing Sounds - Close your eyes and gently notice all sounds around you without labeling and judging
* (`body-awareness`) Body Awareness - Mentally scan the body from head to toe, noticing tension or sensation without reacting
* (`focus-on-object`) Focus on the Object - Look at the single object (e.g. hand, pen, leaf) and observe every detail with full attention
* (`cloud-watching`) Cloud Watching (thoughts) - visualize your thoughts as clouds passing in the sky - watch without holding onto them
* (`mindful-walking`) Mindful Walking - Imagine each step, or physically walk slowly while feeling your feet and body in motion
* (`gratitude-anchor`) Gratitude Anchor - Focus your awareness on one thing you're grateful for - explore why and how it feels

# Grounding Exercises:

* (`54321-technique`) 5-4-3-2-1 Technique (Sensory Grounding) - Name: (5 things you can see, 4 things you can feel, 3 things you can hear, 2 things you can smell, 1 thing you can taste)
* (`body-scan`) Body Scan - Quietly scan through your body from head to toe, noticing tension or sensations
* (`box-breathing`) Box Breathing (Navy SEAL method) - Inhale 4s -> Hold 4s -> Exhale 4s -> Hold 4s, Repeat
* (`object-focus`) Object Focus (Mindful Holding) - Hold and study a small object (e.g. a pen or a key) - its texture, color, temperature
* (`name-label-emotions`) Name and Label Emotions - Pause and write or say: "I feel ____ because _____" -> Repeat 2-3 emotions with root causes
* (`mindful-walk-scroll`) Mindful walk or scroll - walk while observing each step, sound and sensation, no phones
* (`name-surroundings`) Name your surroundings aloud - Out loud or silently: "I am sitting in my room. The floor is carpet. I hear traffic outside"

# Reel Prompt

You are given a reel like video uploaded by my users on a social media app. The purpose of this social media app is to simulate instagram but only for positive content and to make users successful. You have to analyze the video. The response must always be a json. Give me the json response with the following structure:

```ts
interface ReelResponse {
  // any comments relating to the video
  comments: string

  // if the video content is inappropriate, (e.g. it abusive words, or accidents), we will delete the video immediately
  isInappropriate: boolean

  // if video is adult like or is related to pornography, then it will be true. Note that if this is true, we will delete the video plus immediately suspend that user's account, so be careful here, as its only for extremely inappropriate videos
  isExtremelyInappropriate: boolean

  // vector meta data of the video, to be stored in vector databases later for AI suggested contents
  vectorMetaData: number[]

  // for those videos which has positive content, e.g. to focus on discipline, to grow, etc
  isPositive?: boolean

  // for those videos which has negative content, e.g. comedy, memes, girls addictive, etc which gives instant gratification, Note that these are just for negative content and should be confused with inappropriate. A negative content video can be fully appropriate as its just a social media, so its common to have fun like videos
  isNegative?: boolean

  // here are the list of all the categories so that you can know if the video lies in awareness exercises category, if yes, then in the array provides all the keys of those which follows as per this list:
  // * (`mindful-breathing`) Mindful breathing - focus on the sensation of your breadth, inhale and exhale slowly, returning focus when distracted
  // * (`noticing-sound`) Noticing Sounds - Close your eyes and gently notice all sounds around you without labeling and judging
  // * (`body-awareness`) Body Awareness - Mentally scan the body from head to toe, noticing tension or sensation without reacting
  // * (`focus-on-object`) Focus on the Object - Look at the single object (e.g. hand, pen, leaf) and observe every detail with full attention
  // * (`cloud-watching`) Cloud Watching (thoughts) - visualize your thoughts as clouds passing in the sky - watch without holding onto them
  // * (`mindful-walking`) Mindful Walking - Imagine each step, or physically walk slowly while feeling your feet and body in motion
  // * (`gratitude-anchor`) Gratitude Anchor - Focus your awareness on one thing you're grateful for - explore why and how it feels
  awarenessExercise?: ('mindful-breathing' | 'noticing-sound' | 'body-awareness' | 'focus-on-object' | 'cloud-watching' | 'mindful-walking' | 'gratitude-anchor')[]


  // here are the list of all the categories so that you can know if the video lies in grounding exercises category, if yes, then in the array provides all the keys of those which follows as per this list:
  // * (`54321-technique`) 5-4-3-2-1 Technique (Sensory Grounding) - Name: (5 things you can see, 4 things you can feel, 3 things you can hear, 2 things you can smell, 1 thing you can taste)
  // * (`body-scan`) Body Scan - Quietly scan through your body from head to toe, noticing tension or sensations
  // * (`box-breathing`) Box Breathing (Navy SEAL method) - Inhale 4s -> Hold 4s -> Exhale 4s -> Hold 4s, Repeat
  // * (`object-focus`) Object Focus (Mindful Holding) - Hold and study a small object (e.g. a pen or a key) - its texture, color, temperature
  // * (`name-label-emotions`) Name and Label Emotions - Pause and write or say: "I feel ____ because _____" -> Repeat 2-3 emotions with root causes
  // * (`mindful-walk-scroll`) Mindful walk or scroll - walk while observing each step, sound and sensation, no phones
  // * (`name-surroundings`) Name your surroundings aloud - Out loud or silently: "I am sitting in my room. The floor is carpet. I hear traffic outside"
  groundingExercise?: ('54321-technique' | 'body-scan' | 'box-breathing' | 'object-focus' | 'name-label-emotions' | 'mindful-walk-scroll' | 'name-surroundings')[]

  // whether this video lies in the category of making a person productive
  isProductivity?: boolean

  // whether this video lies in the category of making a person calm, or is in the category of meditation
  isMeditation?: boolean
}
```

Finally, Make sure your response must be a valid json string which can be parsed by JSON parsers, i.e. it should not have any characters like "```json", or - "Sure here is your response: {...}", etc
