import { Request, Response } from 'express'
import { IAdmin, Admin } from './models'
import helpers from '../../utils/helpers'

async function getProfile(req: Request, res: Response) {
  try {
    let admin = res.locals.admin as IAdmin

    // @ts-ignore
    admin.auth = undefined

    return res.json({ admin })
  } catch (error) {
    console.log(error)
    return res.status(500).json({ message: 'server error' })
  }
}

const controllers = {
  getProfile,
}

export default controllers
