import { Schema, model, Document, Types } from 'mongoose'
import { AuthSchema, IAuth } from '../users/models'

const AdminSchema = new Schema(
	{
		name: {
			type: String,
			required: true,
			trim: true,
		},
		email: {
			type: String,
			required: true,
			unique: true,
			match: /^[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,}$/i
		},
		phone: String,
		auth: {
			type: AuthSchema,
			required: true,
		},
	},
	{ versionKey: false, timestamps: true }
)

export interface IAdmin extends Document {
	_id: Types.ObjectId
	name: string
	email: string
	phone?: string
	auth: IAuth
	createdAt: Date
	updatedAt: Date
}

export const Admin = model('Admin', AdminSchema, 'admins')
