import { Request, Response } from 'express'
import { Admin } from '../../admin/models'
import helpers from '../../../utils/helpers'

async function postLogin(req: Request, res: Response) {
	try {
		let { email, password } = req.body
		const admin = await Admin.findOne({ email })
		if (!admin) {
			return res.status(404).json({ message: 'admin not found' })
		}

		const hash = helpers.getHash(password)
		if (admin.auth.password !== hash) {
			return res.status(401).json({ message: 'authentication failed' })
		}

    // @ts-ignore
		const token = helpers.getToken(admin)
		return res.json({ token })
	} catch (error) {
		console.log(error)
		return res.status(500).json({ message: 'server error' })
	}
}

const controllers = {
	postLogin,
}

export default controllers
