[Goto Home](/docs/index.html)

# 🌍 POST `/auth/login`

## Description

- Returns token after login
- user's email must be verified before login
- If `remember` is not `true`, then token will expire in 24 hours, (Default value of remember is `true`)
- If 2FA for that user is enabled (disabled by default), then it sends `2faToken` instead of token, and sends otp to his email
- If 2FA is enabled, then user can also send `phone` field as `true`, this will send otp to his phone instead of his email
- In case of user account is terminated, then it also returns a field `terminated: true` in request body with status code `403`
- In case of user email is not verified, then it also returns a field `verificationRequired: true` in request body with status code `403`

## Request Body

```js
{
  email: 'john@example.com'
  password: '12345678'
  phone?: true
  remember?: true
  platform: 'android' | 'ios' | 'web'
  fcmToken?: 'dummytoken:APA91bF6xXyZ0lW7kT8U4QkW9ZJ3aK6YgM5h2jLmNpQrStUvWxYz1234567890abcdefGhIjKlMnOpQrStUvWxYzAbCdEfGhIjKlMnOpQrStUvWxYz'
}
```

## Response Body

```js
{
  token?: 'abc'
  '2faToken'?: 'abc'
  id?: string
}
```

# 🌍 POST `/auth/google-login`

## Description

- Use this api after doing google login on client side
- Returns `token` after doing google login
- Returns `decoded` in error cases also (as long as `googleToken` is valid)
- user's email must be verified
- If user don't exist, then it returns `404` status with `decoded` field, in this case registration is required from the `decoded` data
- If `remember` is not `true`, then token will expire in 24 hours
- In case of user account is terminated, then it also returns a field `terminated: true` in request body with status code `403`
- In case of user email is not verified, then it also returns a field `verificationRequired: true` in request body with status code `403`

## Request Body

```js
{
  googleToken: string
  remember?: true
  platform: 'android' | 'ios' | 'web',
  fcmToken?: 'dummytoken:APA91bF6xXyZ0lW7kT8U4QkW9ZJ3aK6YgM5h2jLmNpQrStUvWxYz1234567890abcdefGhIjKlMnOpQrStUvWxYzAbCdEfGhIjKlMnOpQrStUvWxYz'
}
```

## Response Body

```json
{
  "token": "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJfaWQiOiI2ODcyNjY0MjVmNTc3Y2ZkNWYzNzdkNDgiLCJlbWFpbCI6InJpdHVyYWpzaGFrdGlAZ21haWwuY29tIiwicGhvbmUiOiIrOTExMjQ1NTY3ODkwIiwiaGFzaCI6IjRlNGNmZDk0MWMiLCJpYXQiOjE3NTIzMjc3NDl9.njOh7CKmJg9aSpbmGAqkIyC935SeXds8uOKyauBQJ3w",
  "id": "68bee79857ab80b69867946b",
  "decoded": {
    "iss": "https://accounts.google.com",
    "azp": "747550683140-2juhe5tb4vcbpqhgnvek6pi795p3kqnt.apps.googleusercontent.com",
    "aud": "747550683140-2juhe5tb4vcbpqhgnvek6pi795p3kqnt.apps.googleusercontent.com",
    "sub": "110990247021419178345",
    "email": "riturajshakti@gmail.com",
    "email_verified": true,
    "nbf": 1752327374,
    "name": "Rituraj Shakti",
    "picture": "https://lh3.googleusercontent.com/a/ACg8ocLgA9mv6o_J6QHCtk-AUzxfRQkYBLJMwcacKtlY4qafOKmzN_cZ=s96-c",
    "given_name": "Rituraj",
    "family_name": "Shakti",
    "iat": 1752327674,
    "exp": 1752331274,
    "jti": "16f08a103cd222184aff903413c64d25cf59d3e7"
  }
}
```

# 🌍 POST `/auth/register`

## Description

- Register a new user
- Sends the verification OTP to user email

## Request Body

```js
{
  email: 'raj@gmail.com',
  password: '12345678',
  dob: '1998-01-23'
}
```

# 🌍 POST `/auth/send-otp`

## Description

- Sends the OTP to users email/phone
- If `phone` field is available, then sends OTP to the user phone
- `email` is required
- If already sent otp in last 30 seconds, then don't send it again instead just update otp expiry and `lastOtpSent` timestamp, with success response (`200`)
- In case of user account is terminated, then it also returns a field `terminated: true` in request body with status code `403`

## Request Body

```js
{
  email: 'raj@gmail.com',
  phone?: true
}
```

# 🌍 POST `/auth/check-otp`

## Description

- Checks if email otp is valid
- If `phone` is `true`, then checks phone otp instead of email otp
- If OTP is invalid, return with status `401`
- Also check if OTP is expired, in this case return with status `410`
- Also check if OTP does not exist, in this case return with status `404`
- In case of user account is terminated, then it also returns a field `terminated: true` in request body with status code `403`

## Request Body

```js
{
  email: 'raj@gmail.com',
  otp: '1234',
  phone?: true
}
```

# 🌍 POST `/auth/verify`

## Description

- Verify the email if email otp is valid
- If `phone` is `true`, then checks and verify phone and assume the otp as phone otp
- Reset the OTP and expiry field, once its verified successfully
- In case of user account is terminated, then it also returns a field `terminated: true` in request body with status code `403`

## Request Body

```js
{
  email: 'raj@gmail.com',
  otp: '1234',
  phone?: true,
  platform: 'android' | 'ios' | 'web',
  fcmToken?: 'dummytoken:APA91bF6xXyZ0lW7kT8U4QkW9ZJ3aK6YgM5h2jLmNpQrStUvWxYz1234567890abcdefGhIjKlMnOpQrStUvWxYzAbCdEfGhIjKlMnOpQrStUvWxYz'
}
```

## Response Body

```js
{
  token: 'abc',
  id: '68bee79857ab80b69867946b'
}
```

<!-- # 🌍 POST `/auth/verify-2fa`

## Description

- Verify the `2faToken` and returns the regular `token`
- Reset the OTP and expiry field, once its verified successfully
- In case of user account is terminated, then it also returns a field `terminated: true` in request body with status code `403`

## Request Body

```js
{
  '2faToken': 'abc'
  otp: '1234',
  fcmToken?: 'dummytoken:APA91bF6xXyZ0lW7kT8U4QkW9ZJ3aK6YgM5h2jLmNpQrStUvWxYz1234567890abcdefGhIjKlMnOpQrStUvWxYzAbCdEfGhIjKlMnOpQrStUvWxYz'
}
```

## Response Body

```js
{
  token: 'abc',
  id: string
}
``` -->

# 🌍 POST `/auth/reset-password`

## Description

- Reset password if the email otp is valid
- If `phone` is `true`, then assume the otp as phone otp, and reset the password if otp is valid
- Reset the OTP and expiry field, once its verified successfully
- In case of user account is terminated, then it also returns a field `terminated: true` in request body with status code `403`

## Request Body

```js
{
  email: 'raj@gmail.com',
  otp: '1234',
  password: '12345678'
  phone?: true
}
```

# 🔒 POST `/auth/logout`

## Description

- Properly removes the login device from loggedin devices list


# Links

[Goto Home](/docs/index.html)