import { Router } from 'express'
import validations from './validations'
import controllers from './controllers'
import auth from '../../utils/auth'
const router = Router()

router.post('/login', validations.postLogin, controllers.postLogin)

router.post('/google-login', validations.postGoogleLogin, controllers.postGoogleLogin)

router.post('/register', validations.postRegister, controllers.postRegister)

router.post('/send-otp', validations.postSendOtp, controllers.postSendOtp)

router.post('/check-otp', validations.postCheckOtp, controllers.postCheckOtp)

router.post('/verify', validations.postVerify, controllers.postVerify)

// router.post('/verify-2fa', validations.postVerify2FA, controllers.postVerify2FA)

router.post('/reset-password', validations.postResetPassword, controllers.postResetPassword)

router.post('/logout', auth.authorizeUser, controllers.postLogout)

module.exports = router
