import { Request, Response, NextFunction } from 'express'
import { validate } from 'super-easy-validator'

function postLogin(req: Request, res: Response, next: NextFunction) {
	try {
		const rules = {
			email: 'email',
			password: 'string|min:8|max:16',
			phone: 'optional|boolean',
			remember: 'optional|boolean',
			platform: 'string|enums:android,ios,web',
			fcmToken: 'optional|string|min:50|max:300'
		}
		const { errors } = validate(rules, req.body)
		if (errors) {
			return res.status(400).json({ message: errors[0] })
		}
		return next()
	} catch (error) {
		console.log(error)
		return res.status(500).json({ message: 'server error' })
	}
}

function postGoogleLogin(req: Request, res: Response, next: NextFunction) {
	try {
		const rules = {
			googleToken: 'string|min:100|max:5000',
			remember: 'optional|boolean',
			platform: 'string|enums:android,ios,web',
			fcmToken: 'optional|string|min:50|max:300'
		}
		const { errors } = validate(rules, req.body)
		if (errors) {
			return res.status(400).json({ message: errors[0] })
		}
		return next()
	} catch (error) {
		console.log(error)
		return res.status(500).json({ message: 'server error' })
	}
}

function postRegister(req: Request, res: Response, next: NextFunction) {
	try {
		const rules = {
			email: 'email',
			password: 'string|min:8|max:16',
			dob: 'dateonly',
		}
		const { errors } = validate(rules, req.body)
		if (errors) {
			return res.status(400).json({ message: errors[0] })
		}
		return next()
	} catch (error) {
		console.log(error)
		return res.status(500).json({ message: 'server error' })
	}
}

function postSendOtp(req: Request, res: Response, next: NextFunction) {
	try {
		const rules = {
			email: 'email',
			phone: 'optional|boolean'
		}
		const { errors } = validate(rules, req.body)
		if (errors) {
			return res.status(400).json({ message: errors[0] })
		}
		return next()
	} catch (error) {
		console.log(error)
		return res.status(500).json({ message: 'server error' })
	}
}

function postCheckOtp(req: Request, res: Response, next: NextFunction) {
	try {
		const rules = {
			email: 'email',
			otp: 'string|natural|size:4',
			phone: 'optional|boolean'
		}
		const { errors } = validate(rules, req.body)
		if (errors) {
			return res.status(400).json({ message: errors[0] })
		}
		return next()
	} catch (error) {
		console.log(error)
		return res.status(500).json({ message: 'server error' })
	}
}

function postVerify(req: Request, res: Response, next: NextFunction) {
	try {
		const rules = {
			email: 'email',
			otp: 'string|natural|size:4',
			phone: 'optional|boolean',
			platform: 'string|enums:android,ios,web',
			fcmToken: 'optional|string|min:50|max:300'
		}
		const { errors } = validate(rules, req.body)
		if (errors) {
			return res.status(400).json({ message: errors[0] })
		}
		return next()
	} catch (error) {
		console.log(error)
		return res.status(500).json({ message: 'server error' })
	}
}

function postVerify2FA(req: Request, res: Response, next: NextFunction) {
	try {
		const rules = {
			'2faToken': 'string|min:10|max:1000',
			otp: 'string|natural|size:4',
			fcmToken: 'optional|string|min:50|max:300'
		}
		const { errors } = validate(rules, req.body)
		if (errors) {
			return res.status(400).json({ message: errors[0] })
		}
		return next()
	} catch (error) {
		console.log(error)
		return res.status(500).json({ message: 'server error' })
	}
}

function postResetPassword(req: Request, res: Response, next: NextFunction) {
	try {
		const rules = {
			email: 'email',
			otp: 'string|natural|size:4',
			password: 'string|min:8|max:16',
			phone: 'optional|boolean'
		}
		const { errors } = validate(rules, req.body)
		if (errors) {
			return res.status(400).json({ message: errors[0] })
		}
		return next()
	} catch (error) {
		console.log(error)
		return res.status(500).json({ message: 'server error' })
	}
}

const validations = {
	postLogin,
	postGoogleLogin,
	postRegister,
	postVerify,
	postVerify2FA,
	postSendOtp,
	postCheckOtp,
	postResetPassword,
}

export default validations
