[Goto Home](/docs/index.html)

# 🔒 GET `/blockings`

## Description

- Returns the list of blocked users by this user as per pagination

## Request Query

- **limit** - default `10`, set the number of items to return on each api call
- **page** - default `1`, set the page number

## Response Body

```json
{
  "blockings": [
    {
      "_id": "68bfe9573d353eb94a01d3d6",
      "user": {
        "_id": "689b302a132cd7d169e76e6a",
        "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/689b302a132cd7d169e76e6a/1755000957112-20255307263548894-1755000955826-c4918911-867e-4b03-ba35-637fd58b607b.jpeg.jpg"
      },
      "blockedBy": "68b5931b4d5c718924c59a40",
      "at": "2025-09-09T08:46:15.000Z"
    }
  ],
  "count": 1
}
```

# 🔒 POST `/blockings/:userId`

## Description

- Block this user for the current user
- Update one-to-one `chat.blocked`

## Response Body

```json
{
  "blocking": {
    "user": "689b302a132cd7d169e76e6a",
    "blockedBy": "68b5931b4d5c718924c59a40",
    "_id": "68bfe91d3d353eb94a01d3c4",
    "at": "2025-09-09T08:45:17.000Z"
  }
}
```

# 🔒 DELETE `/blockings/:userId`

## Description

- Delete the blocking for the current user
- Update one-to-one `chat.blocked`

# Links

[Goto Home](/docs/index.html)