import { Schema, model, Document, Types } from 'mongoose'

const BlockingSchema = new Schema(
	{
		user: {
			type: Types.ObjectId,
      ref: 'User',
			required: true,
		},
		blockedBy: {
			type: Types.ObjectId,
      ref: 'User',
			required: true,
		},
		at: {
			type: Date,
			default: Date
		},
	},
	{ versionKey: false }
)

export interface IBlocking extends Document {
	_id: Types.ObjectId
	user: Types.ObjectId
	blockedBy: Types.ObjectId
	at: Date
}

export const Blocking = model('Blocking', BlockingSchema, 'blockings')
