import { Router } from 'express'
import validations from './validations'
import controllers from './controllers'
import auth from '../../utils/auth'
const router = Router()

router.get('/', validations.getBlockings, auth.authorizeUser, controllers.getBlockings)

router.post('/:userId', validations.checkBlockingId, auth.authorizeUser, controllers.postBlocking)

router.delete('/:userId', validations.checkBlockingId, auth.authorizeUser, controllers.deleteBlocking)

module.exports = router
