import { Router } from 'express'
import validations from './validations'
import controllers from './controllers'
import auth from '../../utils/auth'
import { ImageUploader } from '../../utils/uploaders'
const router = Router()

router.get('/', validations.getChats, auth.authorizeUser, controllers.getChats)

router.get('/:id', validations.validateChatId, auth.authorizeUser, controllers.getChat)

router.get('/explore/communities', validations.getExploreChats, auth.authorizeUser, controllers.getExploreChats)

router.get('/:id/files', validations.getChatFiles, auth.authorizeUser, controllers.getChatFiles)

router.post('/', validations.postChat, auth.authorizeUser, controllers.postChat)

router.put('/:id', ImageUploader.fields([{name: 'photo', maxCount: 1}]), validations.putChat, auth.authorizeUser, controllers.putChat)

router.post('/:id/read', validations.validateChatId, auth.authorizeUser, controllers.postChatRead)

router.post('/:id/participants', validations.postChatParticipant, auth.authorizeUser, controllers.postChatParticipant)

router.post('/:id/participants/multiple', validations.postChatParticipants, auth.authorizeUser, controllers.postChatParticipants)

router.post('/:id/participants/:participantId/status', validations.postChatParticipantStatus, auth.authorizeUser, controllers.postChatParticipantStatus)

router.delete('/:id/participants/:participantId', validations.deleteChatParticipant, auth.authorizeUser, controllers.deleteChatParticipant)

router.post('/:id/participants/:participantId/admin', validations.validateChatParticipantId, auth.authorizeUser, controllers.postChatParticipantAdmin)

router.delete('/:id/participants/:participantId/admin', validations.validateChatParticipantId, auth.authorizeUser, controllers.deleteChatParticipantAdmin)

router.delete('/:id', validations.validateChatId, auth.authorizeUser, controllers.deleteChat)

module.exports = router
