[Goto Home](/docs/index.html)

# 🔒 GET `/comments`

## Description

- Returns the list of comments for the given specific reel
- If `parent` is given, then return the nested comments only as per pagination
- If `parent` is not given, then return the root comments only as per pagination
- Populate its `user` data
- Also Populate users in `data` field

## Request Query

- **reel** - required, the ID of the reel from which the comments should belong to
- **parent** - optional, the ID of the parent comment from which the comments should belong to
- **limit** - default `10`, set the number of items to return on each page
- **page** - default `1`, set the page for which to return the items

## Response Body

```json
{
  "comments": [
    {
      "_id": "68b1a0cc886ae993a645a23c",
      "user": {
        "_id": "68906b08a3bf95fd187f7a22",
        "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68906b08a3bf95fd187f7a22/1754389726864-11352239567863498-1754389725491-7560383e-1930-4c67-bcca-4e0835815860.jpeg.jpg",
        "name": "QA User",
        "username": "Maneesha_G_K"
      },
      "reel": "68b009f81d36e414df06f6fa",
      "parent": "68b19a61318896320365a2aa",
      "data": [
        {
          "text": "We should learn from"
        },
        {
          "user": {
            "_id": "68906b08a3bf95fd187f7a22",
            "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68906b08a3bf95fd187f7a22/1754389726864-11352239567863498-1754389725491-7560383e-1930-4c67-bcca-4e0835815860.jpeg.jpg",
            "name": "QA User",
            "username": "Maneesha_G_K"
          }
        },
        {
          "text": "He is so disciplined and healthy"
        }
      ],
      "superLike": "68b19a88318896320365a2b1",
      "likes": 0,
      "totalReplies": 3,
      "createdAt": "2025-08-29T12:45:00.386Z",
      "updatedAt": "2025-08-29T12:49:16.074Z"
    },
    {
      "_id": "68b1a001a1f463a1b9cf1485",
      "user": {
        "_id": "68906b08a3bf95fd187f7a22",
        "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68906b08a3bf95fd187f7a22/1754389726864-11352239567863498-1754389725491-7560383e-1930-4c67-bcca-4e0835815860.jpeg.jpg",
        "name": "QA User",
        "username": "Maneesha_G_K"
      },
      "reel": "68b009f81d36e414df06f6fa",
      "parent": "68b19a61318896320365a2aa",
      "data": [
        {
          "user": {
            "_id": "68906b08a3bf95fd187f7a22",
            "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68906b08a3bf95fd187f7a22/1754389726864-11352239567863498-1754389725491-7560383e-1930-4c67-bcca-4e0835815860.jpeg.jpg",
            "name": "QA User",
            "username": "Maneesha_G_K"
          }
        },
        {
          "text": "Your comment is underrated"
        }
      ],
      "superLike": "68b19a88318896320365a2b1",
      "likes": 0,
      "totalReplies": 0,
      "createdAt": "2025-08-29T12:41:37.779Z",
      "updatedAt": "2025-08-29T12:41:37.779Z"
    },
    {
      "_id": "68b19fd7a1f463a1b9cf1478",
      "user": {
        "_id": "68906b08a3bf95fd187f7a22",
        "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68906b08a3bf95fd187f7a22/1754389726864-11352239567863498-1754389725491-7560383e-1930-4c67-bcca-4e0835815860.jpeg.jpg",
        "name": "QA User",
        "username": "Maneesha_G_K"
      },
      "reel": "68b009f81d36e414df06f6fa",
      "parent": "68b19a61318896320365a2aa",
      "data": [
        {
          "user": {
            "_id": "68906b08a3bf95fd187f7a22",
            "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68906b08a3bf95fd187f7a22/1754389726864-11352239567863498-1754389725491-7560383e-1930-4c67-bcca-4e0835815860.jpeg.jpg",
            "name": "QA User",
            "username": "Maneesha_G_K"
          }
        },
        {
          "text": "Your comment is underrated"
        }
      ],
      "superLike": "68b19a88318896320365a2b1",
      "likes": 0,
      "totalReplies": 2,
      "createdAt": "2025-08-29T12:40:55.177Z",
      "updatedAt": "2025-08-29T12:40:55.177Z"
    }
  ],
  "count": 3
}
```

# 🔒 POST `/comments`

## Description

- Create new comment
- Update its corresponding Reel's `comments` count
- Also check if this user has super-liked, and update `superLike` accordingly
- If `parent` comment id given, then that comment must be the root comment and must belong to this reel
- All the user given in data must exist
- Notify the reel creator with event `comment-created` if user is different
- If comment is nested comment, then also notify the parent comment creator but only if creator is different person with the event `comment-created`
- If comment is a kind comment/thankyou comment, then update `mindful-comments` and `mindful-comment-reply`(if its a reply on any comment) of vibe social score and send socket notification with event `score-updated`

## Request Body

```json
{
  "reel": "68b009f81d36e414df06f6fa",
  "parent": "68b19a61318896320365a2aa",
  "data": [
    {"text": "We should learn from"},
    {"user": "68906b08a3bf95fd187f7a22"},
    {"text": "He is so disciplined"}
  ]
}
```

## Response Body

```json
{
  "comment": {
    "_id": "68b1a0cc886ae993a645a23c",
    "user": {
      "_id": "68906b08a3bf95fd187f7a22",
      "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68906b08a3bf95fd187f7a22/1754389726864-11352239567863498-1754389725491-7560383e-1930-4c67-bcca-4e0835815860.jpeg.jpg",
      "name": "QA User",
      "username": "Maneesha_G_K"
    },
    "reel": "68b009f81d36e414df06f6fa",
    "parent": "68b19a61318896320365a2aa",
    "data": [
      {
        "text": "We should learn from"
      },
      {
        "user": {
          "_id": "68906b08a3bf95fd187f7a22",
          "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68906b08a3bf95fd187f7a22/1754389726864-11352239567863498-1754389725491-7560383e-1930-4c67-bcca-4e0835815860.jpeg.jpg",
          "name": "QA User",
          "username": "Maneesha_G_K"
        }
      },
      {
        "text": "He is so disciplined"
      }
    ],
    "superLike": "68b19a88318896320365a2b1",
    "likes": 0,
    "createdAt": "2025-08-29T12:45:00.386Z",
    "updatedAt": "2025-08-29T12:45:00.386Z"
  }
}
```

# 🔒 PATCH `/comments/:id`

## Description

- Update the comment
- User must be the creator of that comment
- All the user given in data must exist
- Notify the reel creator with event `comment-updated` if user is different
- If comment is nested comment, then also notify the parent comment creator but only if creator is different person with the event `comment-updated`

## Request Body

```json
{
  "data": [
    {"text": "We should learn from"},
    {"user": "68906b08a3bf95fd187f7a22"},
    {"text": "He is so disciplined and healthy"}
  ]
}
```

## Response Body

```json
{
  "comment": {
    "_id": "68b1a0cc886ae993a645a23c",
    "user": {
      "_id": "68906b08a3bf95fd187f7a22",
      "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68906b08a3bf95fd187f7a22/1754389726864-11352239567863498-1754389725491-7560383e-1930-4c67-bcca-4e0835815860.jpeg.jpg",
      "name": "QA User",
      "username": "Maneesha_G_K"
    },
    "reel": "68b009f81d36e414df06f6fa",
    "parent": "68b19a61318896320365a2aa",
    "data": [
      {
        "text": "We should learn from"
      },
      {
        "user": {
          "_id": "68906b08a3bf95fd187f7a22",
          "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68906b08a3bf95fd187f7a22/1754389726864-11352239567863498-1754389725491-7560383e-1930-4c67-bcca-4e0835815860.jpeg.jpg",
          "name": "QA User",
          "username": "Maneesha_G_K"
        }
      },
      {
        "text": "He is so disciplined and healthy"
      }
    ],
    "superLike": "68b19a88318896320365a2b1",
    "likes": 0,
    "createdAt": "2025-08-29T12:45:00.386Z",
    "updatedAt": "2025-08-29T12:49:16.074Z"
  }
}
```

# 🔒 DELETE `/comments/:id`

## Description

- Deletes the comment
- User must be the creator of that comment
- Delete all its sub-comments
- Delete all its likes
- Update its corresponding Reel's `comments` count

# Links

[Goto Home](/docs/index.html)