import { Router } from 'express'
import validations from './validations'
import controllers from './controllers'
import auth from '../../utils/auth'
const router = Router()

router.get('/', validations.getComments, auth.authorizeUser, controllers.getComments)

router.post('/', validations.postComment, auth.authorizeUser, controllers.postComment)

router.patch('/:id', validations.patchComment, auth.authorizeUser, controllers.patchComment)

router.delete('/:id', validations.deleteComment, auth.authorizeUser, controllers.deleteComment)

module.exports = router
