import { Schema, model, Document, Types } from 'mongoose'

const ConnectionSchema = new Schema(
	{
		from: {
			type: Types.ObjectId,
      ref: 'User',
			required: true,
		},
		to: {
			type: Types.ObjectId,
      ref: 'User',
			required: true,
		},
		statusDetail: {
			type: Types.ObjectId,
      ref: 'Status',
		},
		status: {
			type: String,
			enum: ['pending', 'accepted'],
			default: 'pending',
		},
		chat: {
			type: Types.ObjectId,
			ref: 'Chat'
		},
		createdAt: {
			type: Date,
			default: Date
		},
		acceptedAt: Date
	},
	{ versionKey: false }
)

export interface IConnection extends Document {
	_id: Types.ObjectId
	from: Types.ObjectId
	to: Types.ObjectId
	statusDetail?: Types.ObjectId
	status: 'pending' | 'accepted'
	chat?: Types.ObjectId
	acceptedAt?: Date
	createdAt: Date
}

export const Connection = model('Connection', ConnectionSchema, 'connections')
