import { Router } from 'express'
import validations from './validations'
import controllers from './controllers'
import auth from '../../utils/auth'
const router = Router()

router.get('/', validations.getConnections, auth.authorizeUser, controllers.getConnections)

router.post('/:userId', validations.checkUserId, auth.authorizeUser, controllers.postConnection)

router.post('/:userId/accept', validations.checkUserId, auth.authorizeUser, controllers.postAcceptConnection)

router.delete('/:userId', validations.checkUserId, auth.authorizeUser, controllers.deleteConnection)

module.exports = router
