import { Request, Response, NextFunction } from 'express'
import { validate } from 'super-easy-validator'

function getConnections(req: Request, res: Response, next: NextFunction) {
	try {
		const rules = {
			limit: 'optional|string|natural',
			page: 'optional|string|natural',
			status: 'optional|enums:pending,accepted'
		}

		const { errors } = validate(rules, req.query)
		if (errors) {
			return res.status(400).json({ message: errors[0] })
		}

		return next()
	} catch (error) {
		console.log(error)
		return res.status(500).json({ message: 'server error' })
	}
}

function checkUserId(req: Request, res: Response, next: NextFunction) {
	try {
		const rules = {
			userId: 'mongoid'
		}

		const { errors } = validate(rules, req.params)
		if (errors) {
			return res.status(400).json({ message: errors[0] })
		}

		return next()
	} catch (error) {
		console.log(error)
		return res.status(500).json({ message: 'server error' })
	}
}

const validations = {
	getConnections,
	checkUserId
}

export default validations
