import { Request, Response } from 'express'
import { IUser } from '../users/models'
import { ContactUs as Contact } from './models'

async function postContactUs(req: Request, res: Response) {
	interface Payload {
		name: string
		email: string
		phone?: string
		message?: string
	}
	try {
		const { name, email, phone, message } = req.body as Payload
		const user = res.locals.user as IUser | undefined

		await Contact.create({
			user: user?._id,
			name,
			email,
			phone,
			message
		})

		return res.status(201).json({ message: 'contact request submitted successfully' })
	} catch (error) {
		console.log(error)
		return res.status(500).json({ message: 'server error' })
	}
}

const controllers = {
	postContactUs
}

export default controllers
