import { Schema, model, Document, Types } from 'mongoose'

const ContactUsSchema = new Schema(
	{
		user: {
			type: Types.ObjectId,
      ref: 'User',
		},
		name: {
			type: String,
			required: true
		},
		email: {
			type: String,
			required: true
		},
		phone: String,
		message: String
	},
	{ versionKey: false, timestamps: true }
)

export interface IContactUs extends Document {
	_id: Types.ObjectId
	user?: Types.ObjectId
	name: string
	email: string
	phone?: string
	message?: string
	createdAt: Date
  updatedAt: Date
}

export const ContactUs = model('ContactUs', ContactUsSchema, 'contact-us')
