import { Request, Response, NextFunction } from 'express'
import { validate } from 'super-easy-validator'

function postContactUs(req: Request, res: Response, next: NextFunction) {
	try {
		const rules = {
			name: 'string|min:1|max:40',
			email: 'email',
			phone: 'optional|string|min:1|max:18',
			message: 'optional|string|min:3|max:500'
		}

		const { errors } = validate(rules, req.body)
		if (errors) {
			return res.status(400).json({ message: errors[0] })
		}

		return next()
	} catch (error) {
		console.log(error)
		return res.status(500).json({ message: 'server error' })
	}
}

const validations = {
	postContactUs
}

export default validations
