import { Schema, model, Document, Types } from 'mongoose'

const ContactSchema = new Schema(
	{
		user: {
			type: Types.ObjectId,
      ref: 'User',
			required: true,
			unique: true
		},
		contacts: {
			type: [Object],
			default: []
		}
	},
	{ versionKey: false, timestamps: true }
)

export interface IContact extends Document {
	_id: Types.ObjectId
	user: Types.ObjectId
	contacts: Record<string, any>[]
	createdAt: Date
  updatedAt: Date
}

export const Contact = model('Contact', ContactSchema, 'contacts')
