import { Request, Response, NextFunction } from 'express'
import { validate } from 'super-easy-validator'

function postContacts(req: Request, res: Response, next: NextFunction) {
	try {
		const rules = {
			contacts: 'arrayof:object'
		}

		const { errors } = validate(rules, req.body)
		if (errors) {
			return res.status(400).json({ message: errors[0] })
		}

		return next()
	} catch (error) {
		console.log(error)
		return res.status(500).json({ message: 'server error' })
	}
}

const validations = {
	postContacts
}

export default validations
