import { Schema, model, Document, Types } from 'mongoose'
import constants from '../../utils/constants'

const DeletionSchema = new Schema(
	{
		collections: {
			type: String,
			required: true
		},
		user: {
			type: Types.ObjectId,
			enum: constants.collections,
      ref: 'User'
		},
		data: {
			type: Schema.Types.Mixed,
			required: true
		},
		at: {
			type: Date,
			default: Date
		}
	},
	{ versionKey: false }
)

export interface IDeletion extends Document {
	_id: Types.ObjectId
	user: Types.ObjectId
	collections: typeof constants.collections[number]
	data: Record<string, any>
	at: Date
}

export const Deletion = model('Deletion', DeletionSchema, 'deletions')
