[Goto Home](/docs/index.html)

# 🔒 GET `/events`

## Description

- Returns the list of all events of different users
- Only show upcoming/running events
- As per the type, either return _my events_ or _other people events_
- If user don't have any location field or if `type` is `mine`, then location filter would be disabled

## Request Query

- **limit** - default `10`, set the number of items to return on each page
- **page** - default `1`, set the page for which to return the items
- **type** - possible values: `mine`, `others`; returns the type of events, i.e. my events or other people events
- **search** - apply search filter for user based on user name
- **categories** - sets the categories filter for events, must be comma separated, e.g. `Gym,Open for Anything`

## Response Body

```json
{
  "events": [
    {
      "_id": "68e74a9dc73d76d52600a9e0",
      "user": "68906b08a3bf95fd187f7a22",
      "title": "Let's Plant Many Trees",
      "description": "Lets meet at this sunday, plant many trees and make our nature healthy",
      "date": "2025-10-13",
      "time": "11:00 AM",
      "joined": true,
      "location": {
        "type": "Point",
        "coordinates": [
          -71.0948037,
          42.360092
        ]
      },
      "locationString": "77 Massachusetts Ave, Cambridge, MA 02139, United States",
      "chat": {
        "_id": "68e74a9dc73d76d52600a9de",
        "creator": "68906b08a3bf95fd187f7a22",
        "isGroup": true,
        "name": "Let's Plant Many Trees",
        "allowPublicPost": true,
        "areYouAdmin": true,
        "tags": [],
        "participants": [
          {
            "user": "68906b08a3bf95fd187f7a22",
            "isAdmin": true,
            "_id": "68e74a9dc73d76d52600a9df",
            "lastReadAt": "2025-10-09T05:39:41.000Z",
            "status": "accepted"
          }
        ],
        "event": "68e74a9dc73d76d52600a9e0",
        "createdAt": "2025-10-09T05:39:43.114Z",
        "updatedAt": "2025-10-09T06:00:57.837Z"
      },
      "category": "Plants",
      "startedAt": "2025-10-13T05:30:00.000Z",
      "endedAt": "2025-10-13T10:30:00.000Z",
      "createdAt": "2025-10-09T05:39:43.443Z",
      "updatedAt": "2025-10-09T06:02:02.988Z"
    }
  ],
  "count": 1
}
```

# 🔒 GET `/events/:id`

## Description

- Returns the details of specific event

## Response Body

```json
{
  "event": {
    "_id": "68e74a9dc73d76d52600a9e0",
    "user": {
      "_id": "68906b08a3bf95fd187f7a22",
      "email": "john@abc.com",
      "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68906b08a3bf95fd187f7a22/1754389726864-11352239567863498-1754389725491-7560383e-1930-4c67-bcca-4e0835815860.jpeg.jpg",
      "name": "QA User",
      "username": "Maneesha_G_K"
    },
    "title": "Let's Plant Many Trees",
    "description": "Lets meet at this sunday, plant many trees and make our nature healthy",
    "date": "2025-10-13",
    "time": "11:00 AM",
    "location": {
      "type": "Point",
      "coordinates": [
        -71.0948037,
        42.360092
      ]
    },
    "locationString": "77 Massachusetts Ave, Cambridge, MA 02139, United States",
    "chat": "68e74a9dc73d76d52600a9de",
    "category": "Plants",
    "startedAt": "2025-10-13T05:30:00.000Z",
    "endedAt": "2025-10-13T10:30:00.000Z",
    "createdAt": "2025-10-09T05:39:43.443Z",
    "updatedAt": "2025-10-09T06:02:02.988Z"
  }
}
```

# 🔒 POST `/events`

## Description

- Creates a new event
- Also creates the chat
- `date` and `time` combination must be a future timestamp
- In chat participant, make this user as admin

## Request Body (Form Data)

```ts
{
  title: 'Weekend Hangout',   // 5-200 characters
  description: 'Join us for relaxed evening of coffee, chats and networking',     // 10-5000 characters
  date: '2025-10-30',  // YYYY-MM-DD
  time: '11:45 PM',    // hh:mm AM/PM
  locationString: 'Central Park, Rock-port, UK',
  latitude: '12.455',
  longitude: '-34.566',
  category: 'Event',
  cover?: <Image>
}
```

## Response Body

```json
{
  "event": {
    "user": "68906b08a3bf95fd187f7a22",
    "title": "Let's Plant Many Trees",
    "description": "Lets meet at this sunday, plant many trees and make our nature healthy",
    "date": "2025-10-12",
    "time": "11:00 AM",
    "location": {
      "type": "Point",
      "coordinates": [
        -71.0948037,
        42.360092
      ]
    },
    "locationString": "77 Massachusetts Ave, Cambridge, MA 02139, United States",
    "chat": "68e7536e877ea11a33be92e0",
    "category": "Plants",
    "startedAt": "2025-10-12T05:30:00.000Z",
    "endedAt": "2025-10-12T10:30:00.000Z",
    "_id": "68e7536e877ea11a33be92e2",
    "cover": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/chats/68e7536e877ea11a33be92e0/1759990636880-7564535546931638-tree.png",
    "createdAt": "2025-10-09T06:17:19.192Z",
    "updatedAt": "2025-10-09T06:17:19.192Z"
  },
  "chat": {
    "creator": "68906b08a3bf95fd187f7a22",
    "isGroup": true,
    "name": "Let's Plant Many Trees",
    "allowPublicPost": true,
    "tags": [],
    "participants": [
      {
        "user": "68906b08a3bf95fd187f7a22",
        "isAdmin": true,
        "_id": "68e7536e877ea11a33be92e1",
        "lastReadAt": "2025-10-09T06:17:18.000Z"
      }
    ],
    "_id": "68e7536e877ea11a33be92e0",
    "event": "68e7536e877ea11a33be92e2",
    "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/chats/68e7536e877ea11a33be92e0/1759990636880-7564535546931638-tree.png",
    "createdAt": "2025-10-09T06:17:18.872Z",
    "updatedAt": "2025-10-09T06:17:18.872Z"
  }
}
```

# 🔒 PATCH `/events/:id`

## Description

- Updates a new event
- User must be event's chat admin
- If cover is uploaded, then delete the previous image
- update details in both event and chat
- Event should not be expired
- If `date` field is given, then `time` is also required
- If `latitude` field is given, then `longitude` is also required

## Request Body (Form Data)

```ts
{
  title?: 'Weekend Hangout',   // 5-200 characters
  description?: 'Join us for relaxed evening of coffee, chats and networking',     // 10-5000 characters
  date?: '2025-10-30',  // YYYY-MM-DD
  time?: '11:45 PM',    // hh:mm AM/PM
  locationString?: 'Central Park, Rock-port, UK',
  latitude?: '12.455',
  longitude?: '-34.566',
  category?: 'Open for Anything',
  cover?: <Image>
}
```

## Response Body

```json
{
  "cover": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/chats/68e74a9dc73d76d52600a9de/1759990606589-10445846994269603-tree.png",
  "message": "event updated successfully"
}
```

# 🔒 POST `/events/opened-view-all`

## Description

- Update `open-view-all-events` action of vibe social score of that user and send socket notification with event `score-updated`

# Links

[Goto Home](/docs/index.html)

