import { Schema, model, Document, Types } from 'mongoose'
import { ILocation, LocationSchema } from '../../utils/types'

const EventSchema = new Schema(
	{
		user: {
			type: Types.ObjectId,
      ref: 'User',
			required: true,
		},
		title: {
			type: String,
			required: true,
		},
		description: {
			type: String,
			required: true,
		},
		date: {
			type: String,
			required: true
		},
		time: {
			type: String,
			required: true
		},
		location: {
			type: LocationSchema,
			required: true
		},
		locationString: {
			type: String,
			required: true
		},
		chat: {
			type: Types.ObjectId,
			ref: 'Chat',
			required: true
		},
		category: {
			type: String,
			required: true,
		},
		cover: String,
		startedAt: {
			type: Date,
			required: true,
		},
		endedAt: {
			type: Date,
			required: true,
		},
	},
	{ versionKey: false, timestamps: true }
)

EventSchema.index({ location: '2dsphere' });

export interface IEvent extends Document {
	_id: Types.ObjectId
	user: Types.ObjectId
	title: string
	description: string
	date: string  // YYYY-MM-DD
	time: string  // 11:45 PM
	location: ILocation
	locationString: string
	chat: Types.ObjectId
	category: string
	cover?: string
	startedAt: Date
	endedAt: Date
	createdAt: Date
	updatedAt: Date
}

export const Event = model('Event', EventSchema, 'events')
