import { Router } from 'express'
import validations from './validations'
import controllers from './controllers'
import auth from '../../utils/auth'
import { ImageUploader } from '../../utils/uploaders'
const router = Router()

router.get('/', validations.getEvents, auth.authorizeUser, controllers.getEvents)

router.get('/:id', validations.checkEventId, auth.authorizeUser, controllers.getEvent)

router.post('/', ImageUploader.single('cover'), validations.postEvent, auth.authorizeUser, controllers.postEvent)

router.patch('/:id', ImageUploader.single('cover'), validations.patchEvent, auth.authorizeUser, controllers.patchEvent)

router.post('/opened-view-all', auth.authorizeUser, controllers.postOpenedViewAll)

module.exports = router
