[Goto Home](/docs/index.html)

# 🔒 GET `/favorites`

## Description

- Returns the favorite reels of that user as per pagination

## Request Query

- **limit** - default `10`, set the number of items to return on each api call
- **page** - default `1`, set the page number

## Response Body

```json
{
  "favorites": [
    {
      "_id": "68b1945d18b7dbc3c79a4edc",
      "user": {
        "_id": "68906b08a3bf95fd187f7a22",
        "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68906b08a3bf95fd187f7a22/1754389726864-11352239567863498-1754389725491-7560383e-1930-4c67-bcca-4e0835815860.jpeg.jpg",
        "name": "QA User",
        "username": "Maneesha_G_K"
      },
      "reel": {
        "_id": "68a81f57d7f5a437029aa240",
        "user": "68914287e4c3076d9436523c",
        "description": "first upload check - caption ",
        "video": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/reels/68a81f57d7f5a437029aa240/1755848535010-9879905665067813-video_1755.mp4",
        "hashtags": [
          "first",
          "test"
        ],
        "isAnonymous": true,
        "views": 28,
        "likes": 2,
        "superLikes": 2,
        "shares": 0,
        "comments": 0,
        "createdAt": "2025-08-22T07:42:26.250Z",
        "updatedAt": "2025-08-29T11:51:58.360Z"
      },
      "at": "2025-08-29T11:51:57.000Z"
    }
  ],
  "count": 1
}
```

# 🔒 POST `/favorites/:reelId`

## Description

- Adds a new favorite
- Also update the corresponding reel

## Request Body

```json
{
  "favorite": {
    "user": "68906b08a3bf95fd187f7a22",
    "reel": "68b009f81d36e414df06f6fa",
    "_id": "68b192d1fce3645ee3062148",
    "at": "2025-08-29T11:45:21.000Z"
  }
}
```

# 🔒 DELETE `/favorites/:reelId`

## Description

- Delete the favorite
- Also update the corresponding reel

# Links

[Goto Home](/docs/index.html)