import { Router } from 'express'
import validations from './validations'
import controllers from './controllers'
import auth from '../../utils/auth'
const router = Router()

router.get('/', validations.getFavorites, auth.authorizeUser, controllers.getFavorites)

router.post('/:reelId', validations.checkFavoriteId, auth.authorizeUser, controllers.postFavorite)

router.delete('/:reelId', validations.checkFavoriteId, auth.authorizeUser, controllers.deleteFavorite)

module.exports = router
