import { Schema, model, Document, Types } from 'mongoose'

const FollowerSchema = new Schema(
	{
		follower: {
			type: Types.ObjectId,
      ref: 'User',
			required: true,
		},
		following: {
			type: Types.ObjectId,
      ref: 'User',
			required: true,
		},
		at: {
			type: Date,
			default: Date
		}
	},
	{ versionKey: false }
)

FollowerSchema.index({ follower: 1, following: 1 }, { unique: true })

export interface IFollower extends Document {
	_id: Types.ObjectId
	follower: Types.ObjectId
	following: Types.ObjectId
	at: Date
}

export const Follower = model('Follower', FollowerSchema, 'followers')
