import { Router } from 'express'
import validations from './validations'
import controllers from './controllers'
import auth from '../../utils/auth'
const router = Router()

router.get('/', validations.getFollowers, auth.authorizeUser, controllers.getFollowers)

router.post('/:userId', validations.checkUser, auth.authorizeUser, controllers.postFollower)

router.delete('/:userId', validations.checkUser, auth.authorizeUser, controllers.deleteFollower)

module.exports = router
