import { Request, Response, NextFunction } from 'express'
import { validate } from 'super-easy-validator'

function getFollowers(req: Request, res: Response, next: NextFunction) {
	try {
		const rules = {
			limit: 'optional|string|natural',
			page: 'optional|string|natural',
			user: 'optional|mongoid',
			type: 'optional|string|enums:followers,followings'
		}

		const { errors } = validate(rules, req.query)
		if (errors) {
			return res.status(400).json({ message: errors[0] })
		}

		return next()
	} catch (error) {
		console.log(error)
		return res.status(500).json({ message: 'server error' })
	}
}

function checkUser(req: Request, res: Response, next: NextFunction) {
	try {
		const rules = {
			userId: 'mongoid'
		}

		const { errors } = validate(rules, req.params)
		if (errors) {
			return res.status(400).json({ message: errors[0] })
		}

		return next()
	} catch (error) {
		console.log(error)
		return res.status(500).json({ message: 'server error' })
	}
}

const validations = {
	getFollowers,
	checkUser
}

export default validations
