import { Schema, model, Document, Types } from 'mongoose'

const LikeSchema = new Schema(
	{
		user: {
			type: Types.ObjectId,
      ref: 'User',
			required: true,
		},
		reel: {
			type: Types.ObjectId,
      ref: 'Reel',
		},
		comment: {
			type: Types.ObjectId,
      ref: 'Comment',
		},
		at: {
			type: Date,
			default: Date
		}
	},
	{ versionKey: false }
)

export interface ILike extends Document {
	_id: Types.ObjectId
	user: Types.ObjectId
	reel?: Types.ObjectId
	comment?: Types.ObjectId
	at: Date
}

export const Like = model('Like', LikeSchema, 'likes')
