import { Router } from 'express'
import validations from './validations'
import controllers from './controllers'
import auth from '../../utils/auth'
const router = Router()

router.post('/', validations.checkLike, auth.authorizeUser, controllers.postLike)

router.delete('/', validations.checkLike, auth.authorizeUser, controllers.deleteLike)

module.exports = router
