import { Request, Response, NextFunction } from 'express'
import { validate } from 'super-easy-validator'

function checkLike(req: Request, res: Response, next: NextFunction) {
	try {
		const rules = {
			reel: 'optional|mongoid',
			comment: 'optional|mongoid',
			$atleast: 'reel|comment',
			$atmost: 'reel|comment',
		}
		const { errors } = validate(rules, req.body)
		if (errors) {
			return res.status(400).json({ message: errors[0] })
		}

		return next()
	} catch (error) {
		console.log(error)
		return res.status(500).json({ message: 'server error' })
	}
}

const validations = {
	checkLike
}

export default validations
