[Goto Home](/docs/index.html)

# 🔒 GET `/messages/:chatId`

## Description

- Returns the list of messages of that user as per pagination
<!-- - After applying sort (as per `at` in descending) and pagination, final results should be sorted in ascending order -->

## Request Query

- **limit** - default `10`, set the number of items to return on each page
- **page** - default `1`, set the page for which to return the items

## Response Body

```json
{
  "messages": [
    {
      "_id": "68bef0d3e6ca043bb7fe353a",
      "user": {
        "_id": "688c51572b675be4b88339d1",
        "name": "John Doe",
        "username": "john.doe",
        "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/688c51572b675be4b88339d1/1754037385298-15741700714483675-forest_2364458.png",
        "bio": "I am a workaholic"
      },
      "chat": "68bee79857ab80b69867946b",
      "content": "Hi",
      "at": "2025-09-08T15:05:55.000Z"
    },
    {
      "_id": "690495a4ef4fdf219d147a7e",
      "user": {
        "_id": "689b1fca132cd7d169e76e2d",
        "name": "Test User",
        "username": "test.user"
      },
      "chat": "68e7536e877ea11a33be92e0",
      "reel": {
        "_id": "69049529fa7e82996321d4c4",
        "user": "689b1fca132cd7d169e76e2d",
        "chat": "68e7536e877ea11a33be92e0",
        "description": "Motivation",
        "video": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/reels/69049529fa7e82996321d4c4/1761908009117-17680884021849952-motivation.mp4",
        "hashtags": [],
        "isAnonymous": false,
        "views": 0,
        "likes": 0,
        "superLikes": 0,
        "shares": 0,
        "comments": 0,
        "createdAt": "2025-10-31T10:55:32.178Z",
        "updatedAt": "2025-10-31T10:55:33.223Z"
      },
      "at": "2025-10-31T10:55:32.000Z"
    },
    {
      "_id": "68bef2d5f8c1bce4c0bf5e8d",
      "user": {
        "_id": "688c51572b675be4b88339d1",
        "name": "John Doe",
        "username": "john.doe",
        "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/688c51572b675be4b88339d1/1754037385298-15741700714483675-forest_2364458.png",
        "bio": "I am a workaholic"
      },
      "chat": "68bee79857ab80b69867946b",
      "content": "Here are the files",
      "files": [
        {
          "url": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/chats/68bee79857ab80b69867946b/1757344169809-449191050525499-video.mp4",
          "cover": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/chats/68bee79857ab80b69867946b/1757344169809-9816989786237902-cover.jpg",
          "meta": {
            "data": "Its just a dummy data",
            "list": [
              "It",
              "can",
              "have",
              "array",
              "too",
              true,
              100
            ],
            "note": "url is compulsory, rest cover and meta are optional and meta can have any type of data"
          },
          "_id": "68bef2d5f8c1bce4c0bf5e8e"
        },
        {
          "url": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/chats/68bee79857ab80b69867946b/1757344169809-449191050525499-video.mp4",
          "_id": "68bef2d5f8c1bce4c0bf5e8f"
        }
      ],
      "at": "2025-09-08T15:14:29.000Z"
    }
  ],
  "count": 2
}
```

# 🔒 POST `/messages`

## Description

- Creates a new message in that chat
- User must belong to that chat
- Marks all messages as read in that chat
- Update chat's `lastMessage` field
- Push Notify other users in that chat with event `message-received`
- `socket` is the socket ID of the current user, if he's connected to websocket
- handle blocked chat also
- Socket notify other users in that chat with socket event of `message-received`
- Socket Notify current user's other devices with event `message-sent`
- If message is a thoughtful and belongs to a group, or is check-in message in one-to-one chat, then update social vibe score and send socket notification with event `score-updated`
- Update `send-dm-message` action of vibe social score of that user and send socket notification with event `score-updated`
- Socket ID follows this regex:

```js
/^[A-Za-z0-9\-_]{16,25}$/
```

## Request Body

```ts
{
  chat: '68914287e4c3076d9436523c',
  content?: 'My first message',
  files?: [
    {
      url: string,
      cover?: string,
      meta?: object
    },
    {
      url: string
    },
  ],
  socket?: 'u3C2x9asfB9vE5y8A6AD'
}
```

## Response Body

```json
{
  "message": {
    "user": "688c51572b675be4b88339d1",
    "chat": "68bee79857ab80b69867946b",
    "content": "Here are the files",
    "files": [
      {
        "url": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/chats/68bee79857ab80b69867946b/1757344169809-449191050525499-video.mp4",
        "cover": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/chats/68bee79857ab80b69867946b/1757344169809-9816989786237902-cover.jpg",
        "meta": {
          "data": "Its just a dummy data",
          "list": [
            "It",
            "can",
            "have",
            "array",
            "too",
            true,
            100
          ],
          "note": "url is compulsory, rest cover and meta are optional and meta can have any type of data"
        },
        "_id": "68bef2d5f8c1bce4c0bf5e8e"
      },
      {
        "url": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/chats/68bee79857ab80b69867946b/1757344169809-449191050525499-video.mp4",
        "_id": "68bef2d5f8c1bce4c0bf5e8f"
      }
    ],
    "_id": "68bef2d5f8c1bce4c0bf5e8d",
    "at": "2025-09-08T15:14:29.000Z"
  }
}
```

# 🔒 POST `/messages/share-reels`

## Description

- Creates a new reel message in all the given chats
- User must belong to those chats
- Marks all messages as read in all those chats
- Update each chat's `lastMessage` field
- Push Notify other users in their chats with event `message-received`
- Socket notify other users in their chats with socket event of `message-received`
- handle blocked chat also
- Also update reels share count
- If `socket` is given, Socket Notify current user's other devices with event `message-sent` for all those chats separately

## Request Body

```json
{
  "chats": [
    "68914287e4c3076d9436523c",
    "68914287e4c3076d94364c2b"
  ],
  "reel": "68914287e4c3076d9436346c",
  "socket?": "u3C2x9asfB9vE5y8A6AD"
}
```

# 🔒 PATCH `/messages/:id`

## Description

- Updates the message tag
- Files must exist
- User must be admin or the message creator
- handle blocked chat also
- That tag string must be available in the chat `tags`
- Passing `null` in tag field, will delete the tag

## Request Body

```js
{
  tag: string | null
}
```

# 🔒 POST `/messages/presign-url`

## Description

- Generates presign url for every file
- User must belong to that chat
- handle blocked chat also

## Request Body

```ts
{
  chat: '6899c1bbabe4f0b09ab85a46'
  files: ['video.mp4', 'cover.jpg', 'document.pdf']
}
```

## Response Body

```json
{
  "urls": [
    {
      "file": "video.mp4",
      "upload": "https://vibe-dev.bb8af9bf43323edeaeeedf6cfe096189.r2.cloudflarestorage.com/chats/68bee79857ab80b69867946b/1757344169809-449191050525499-video.mp4?X-Amz-Algorithm=AWS4-HMAC-SHA256&X-Amz-Content-Sha256=UNSIGNED-PAYLOAD&X-Amz-Credential=4da98f4064954d2e9c950aa33e1c72ee%2F20250908%2Fauto%2Fs3%2Faws4_request&X-Amz-Date=20250908T150929Z&X-Amz-Expires=1200&X-Amz-Signature=9807d63b165b8c0277e00d8d2c2df4dd1dab1962bd9ab06a2da9e5b2f0ae7cd7&X-Amz-SignedHeaders=host&x-amz-checksum-crc32=AAAAAA%3D%3D&x-amz-sdk-checksum-algorithm=CRC32&x-id=PutObject",
      "download": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/chats/68bee79857ab80b69867946b/1757344169809-449191050525499-video.mp4"
    },
    {
      "file": "cover.jpg",
      "upload": "https://vibe-dev.bb8af9bf43323edeaeeedf6cfe096189.r2.cloudflarestorage.com/chats/68bee79857ab80b69867946b/1757344169809-9816989786237902-cover.jpg?X-Amz-Algorithm=AWS4-HMAC-SHA256&X-Amz-Content-Sha256=UNSIGNED-PAYLOAD&X-Amz-Credential=4da98f4064954d2e9c950aa33e1c72ee%2F20250908%2Fauto%2Fs3%2Faws4_request&X-Amz-Date=20250908T150929Z&X-Amz-Expires=1200&X-Amz-Signature=7324576e7aadb0a0a162d79fea217419701d0d71e69f53f8120d1cec9cf81dfd&X-Amz-SignedHeaders=host&x-amz-checksum-crc32=AAAAAA%3D%3D&x-amz-sdk-checksum-algorithm=CRC32&x-id=PutObject",
      "download": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/chats/68bee79857ab80b69867946b/1757344169809-9816989786237902-cover.jpg"
    }
  ]
}
```

# 🌍 PUT `<presign-url>`

## Description

- Uploads the file on the presign url which is given by previous file
- There won't be any response body in this case, just a status code of `200`

## Request Body

```
<Binary File>
```

# 🔒 DELETE `/messages/:id`

## Description

- Deletes the message
- handle blocked chat also
- Deletes all the files in that message
- User must be the either message creator or chat admin
- If `chat.lastMessage` == `id`, then update the last message in chat

# Links

[Goto Home](/docs/index.html)