import { Router } from 'express'
import validations from './validations'
import controllers from './controllers'
import auth from '../../utils/auth'
const router = Router()

router.get('/:chatId', validations.getMessages, auth.authorizeUser, controllers.getMessages)

router.post('/', validations.postMessage, auth.authorizeUser, controllers.postMessage)

router.post('/share-reels', validations.postMessageShareReels, auth.authorizeUser, controllers.postMessageShareReels)

router.patch('/:id', validations.patchMessage, auth.authorizeUser, controllers.patchMessage)

router.delete('/:id', validations.deleteMessage, auth.authorizeUser, controllers.deleteMessage)

router.post('/presign-url', validations.postPresignUrl, auth.authorizeUser, controllers.postPresignUrl)

module.exports = router
