import { Schema, model, Document, Types } from 'mongoose'

const MiscVersionSchema = new Schema(
	{
		latestVersionString: {
			type: String,
			required: true
		},
		latestVersionCode: {
			type: Number,
			required: true
		},
		minimumVersionString: {
			type: String,
			required: true
		},
		minimumVersionCode: {
			type: Number,
			required: true
		},
	},
	{ versionKey: false, _id: false }
)

export interface IMiscVersion {
	latestVersionString: string
	latestVersionCode: number
	minimumVersionString: string
	minimumVersionCode: number
}

const MiscVersionPlatformSchema = new Schema(
	{
		android: {
			type: MiscVersionSchema,
			required: true
		},
		ios: {
			type: MiscVersionSchema,
			required: true
		},
	},
	{ versionKey: false, _id: false }
)

export interface IMiscVersionPlatform {
	android: IMiscVersion
	ios: IMiscVersion
}

const MiscSchema = new Schema(
	{
		_id: {
			type: String,
			required: true,
		},
		version: {
			type: MiscVersionPlatformSchema,
			required: true,
		},
	},
	{ versionKey: false }
)

export interface IMisc extends Document {
	_id: Types.ObjectId
	version: IMiscVersionPlatform
}

export const Misc = model('Misc', MiscSchema, 'misc')
