import { Schema, model, Document, Types } from 'mongoose'

const MutualFollowSchema = new Schema(
	{
		users: {
      type: [Types.ObjectId],
      ref: 'User',
      required: true,
      validate: (v: Types.ObjectId[]) => v.length === 2
    },
		at: {
			type: Date,
			default: Date
		}
	},
	{ versionKey: false }
)

export interface IMutualFollow extends Document {
	_id: Types.ObjectId
	users: [Types.ObjectId, Types.ObjectId]
	at: Date
}

export const MutualFollow = model('MutualFollow', MutualFollowSchema, 'mutual-follows')
