import { Schema, model, Document, Types } from 'mongoose'
import constants from '../../utils/constants'
import { NotificationEvent } from '../../utils/types'

const NotificationSchema = new Schema(
	{
		user: {
			type: Types.ObjectId,
      ref: 'User',
			required: true,
		},
		data: Object,
		title: {
			type: String,
			required: true
		},
		description: {
			type: String,
			required: true
		},
		event: {
			type: String,
			required: true,
			enum: constants.notificationEvents,
		},
		from: {
			type: Types.ObjectId,
      ref: 'User',
		},
		comment: {
			type: Types.ObjectId,
      ref: 'Comment',
		},
		connection: {
			type: Types.ObjectId,
      ref: 'Connection',
		},
		follower: {
			type: Types.ObjectId,
      ref: 'Follower',
		},
		like: {
			type: Types.ObjectId,
      ref: 'Like',
		},
		superLike: {
			type: Types.ObjectId,
      ref: 'SuperLike',
		},
		reel: {
			type: Types.ObjectId,
      ref: 'Reel',
		},
		status: {
			type: Types.ObjectId,
      ref: 'Status',
		},
		request: {
			type: Types.ObjectId,
      ref: 'Request',
		},
		chat: {
			type: Types.ObjectId,
      ref: 'Chat',
		},
		meetMeEvent: {
			type: Types.ObjectId,
      ref: 'Event',
		},
		rewardHash: {
			type: Types.ObjectId,
			ref: 'RewardHash',
		},
		read: Boolean,
		dismissed: Boolean,
		at: {
			type: Date,
			default: Date
		}
	},
	{ versionKey: false }
)

export interface INotification extends Document {
	_id: Types.ObjectId
	user: Types.ObjectId
	title: string
	description: string
	data?: object
	event: NotificationEvent
	from?: Types.ObjectId
	comment?: Types.ObjectId
	connection?: Types.ObjectId
	follower?: Types.ObjectId
	like?: Types.ObjectId
	superLike?: Types.ObjectId
	reel?: Types.ObjectId
	status?: Types.ObjectId
	request?: Types.ObjectId
	chat?: Types.ObjectId
	meetMeEvent?: Types.ObjectId
	rewardHash?: Types.ObjectId
	read?: boolean
	dismissed?: boolean
	at: Date
}

export const Notification = model('Notification', NotificationSchema, 'notifications')
