[Goto Home](/docs/index.html)

# 🔒 GET `/notifications`

## Description

- Returns the list of all notifications of that user as per pagination

## Request Query

- **limit** - default `10`, set the number of items to return on each page
- **page** - default `1`, set the page for which to return the items
- **unread** - default `false`, if `true` then returns only the unread notifications

## Response Body

```json
{
  "notifications": [
    {
      "_id": "6912a070329d779f876083ba",
      "user": "68ac3f6dd7f5a437029aa88f",
      "title": "Reward Unlocked",
      "description": "Congrats Jass! you have unlocked a new reward",
      "event": "reward-unlocked",
      "rewardHash": {
        "_id": "6912a06f329d779f876083b6",
        "user": "68ac3f6dd7f5a437029aa88f",
        "reward": {
          "_id": "690ca0269c211309c3fe73fa",
          "title": "Nike",
          "description": "Get a discount of upto 5% on Nike Shoes",
          "total": 200,
          "remaining": 200,
          "cover": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/rewards/690ca0269c211309c3fe73fa/1762435110368-44631916485328615-nike.jpg",
          "createdAt": "2025-11-06T13:18:31.607Z",
          "updatedAt": "2025-11-06T13:18:31.607Z"
        },
        "score": "6912963572e3471532c0bd67",
        "at": "2025-11-11T02:33:19.000Z"
      },
      "at": "2025-11-11T02:33:20.000Z"
    },
    {
      "_id": "68b526afc4e015a2a267967b",
      "user": "68906b08a3bf95fd187f7a22",
      "title": "Your reel got a super like",
      "description": "A user amy.jackson has super liked your reel",
      "event": "reel-super-liked",
      "from": {
        "_id": "68914287e4c3076d9436523c",
        "name": "Amy Jackson",
        "username": "amy.jackson",
        "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68914287e4c3076d9436523c/1755602563034-2531577078744356-1755602562142-IMG_0006.jpg.jpg"
      },
      "superLike": {
        "_id": "68b526afc4e015a2a2679679",
        "user": "68914287e4c3076d9436523c",
        "reel": "68a2f0f8a64cd0088270de83",
        "at": "2025-09-01T04:53:03.000Z"
      },
      "reel": {
        "_id": "68a2f0f8a64cd0088270de83",
        "user": "68ac3f6dd7f5a437029aa88f",
        "description": "Move like them, but never think like them",
        "cover": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/reels/68a2f0f8a64cd0088270de83/1755508984234-13163024562999048-cover.png",
        "video": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/reels/68a2f0f8a64cd0088270de83/1755508984234-8557698547342135-mindset.mp4",
        "hashtags": [
          "mindset"
        ],
        "isAnonymous": false,
        "views": 47,
        "likes": 3,
        "superLikes": 4,
        "shares": 5,
        "comments": 0,
        "reports": 0,
        "favorites": 0,
        "createdAt": "2025-08-18T09:28:42.053Z",
        "updatedAt": "2025-09-01T05:02:52.338Z"
      },
      "at": "2025-09-01T04:53:03.000Z",
      "read": true
    },
    {
      "_id": "68c14f085558035c7dd80c62",
      "user": "688c51572b675be4b88339d1",
      "title": "Your comment got a new like",
      "description": "A user raj.example has liked your comment",
      "event": "comment-liked",
      "from": {
        "_id": "68b5931b4d5c718924c59a40",
        "username": "raj.example",
        "name": "Raj Kr",
        "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68b5931b4d5c718924c59a40/1757342480919-7356470458539326-boat.png"
      },
      "comment": {
        "_id": "68c11adb01275c046a1dbc50",
        "user": {
          "_id": "688c51572b675be4b88339d1",
          "name": "John Doe",
          "username": "john.doe",
          "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/688c51572b675be4b88339d1/1754037385298-15741700714483675-forest_2364458.png"
        },
        "reel": "68b198a722d6fb893c9a7276",
        "parent": "68b7da0e8b36c79437df49ed",
        "data": [
          {
            "user": {
              "_id": "68ac3f6dd7f5a437029aa88f",
              "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68ac3f6dd7f5a437029aa88f/1756448241630-9473790384535978-1756448240395-2dcbc7c3-bcc2-4496-b644-2bc8394d20ea.jpeg.jpg",
              "name": "Jass Singh",
              "username": "bat_ma_n"
            }
          },
          {
            "text": " Thanks"
          }
        ],
        "likes": 2,
        "createdAt": "2025-09-10T06:29:47.070Z",
        "updatedAt": "2025-09-11T06:40:50.419Z",
        "superLike": "68c26ef2c388d3033a16b7b1"
      },
      "like": {
        "_id": "68c14f085558035c7dd80c60",
        "user": "68b5931b4d5c718924c59a40",
        "comment": "68c11adb01275c046a1dbc50",
        "at": "2025-09-10T10:12:24.000Z"
      },
      "reel": {
        "_id": "68b198a722d6fb893c9a7276",
        "user": "68ac3f6dd7f5a437029aa88f",
        "description": "Sunsets and the aura it creates",
        "cover": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/reels/68b198a722d6fb893c9a7276/1756469415021-14951173097267556-cover_1756.jpg",
        "video": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/reels/68b198a722d6fb893c9a7276/1756469415021-5853805473432337-video_1756.mp4",
        "hashtags": [
          "sun",
          "aura",
          "life"
        ],
        "isAnonymous": false,
        "views": 86,
        "likes": 4,
        "superLikes": 1,
        "shares": 0,
        "comments": 3,
        "reports": 0,
        "favorites": 1,
        "createdAt": "2025-08-29T12:10:18.311Z",
        "updatedAt": "2025-09-11T08:22:29.169Z"
      },
      "at": "2025-09-10T10:12:24.000Z"
    },
    {
      "_id": "68d3634b63c553dd16ec5336",
      "user": "68b5931b4d5c718924c59a40",
      "title": "A user wants to join the chat",
      "description": "test.user wants to join Just Chit Chat",
      "event": "chat-join-request",
      "from": {
        "_id": "689b1fca132cd7d169e76e2d",
        "name": "Test User",
        "username": "test.user"
      },
      "request": {
        "_id": "68d3634a63c553dd16ec5332",
        "user": {
          "_id": "689b1fca132cd7d169e76e2d",
          "name": "Test User",
          "username": "test.user"
        },
        "chat": "68d2db946da2eec7efd20576",
        "status": "accepted",
        "createdAt": "2025-09-24T03:19:38.000Z",
        "acceptedAt": "2025-09-24T03:21:00.984Z"
      },
      "chat": {
        "_id": "68d2db946da2eec7efd20576",
        "creator": {
          "_id": "68914287e4c3076d9436523c",
          "name": "Amy Jackson",
          "username": "amy.jackson",
          "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68914287e4c3076d9436523c/1755602563034-2531577078744356-1755602562142-IMG_0006.jpg.jpg"
        },
        "isGroup": true,
        "areYouAdmin": true,
        "name": "Just Chit Chat",
        "participants": [
          {
            "user": {
              "_id": "68914287e4c3076d9436523c",
              "name": "Amy Jackson",
              "username": "amy.jackson",
              "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68914287e4c3076d9436523c/1755602563034-2531577078744356-1755602562142-IMG_0006.jpg.jpg"
            },
            "_id": "68d2db946da2eec7efd20578",
            "lastReadAt": "2025-09-23T17:48:53.933Z"
          },
          {
            "user": {
              "_id": "68b5931b4d5c718924c59a40",
              "username": "raj.example",
              "name": "Raj Kr",
              "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68b5931b4d5c718924c59a40/1757342480919-7356470458539326-boat.png"
            },
            "_id": "68d2df16edbe3f35fa067ec2",
            "lastReadAt": "2025-09-23T17:55:34.000Z",
            "isAdmin": true
          },
          {
            "user": {
              "_id": "689b1fca132cd7d169e76e2d",
              "name": "Test User",
              "username": "test.user"
            },
            "_id": "68d3639d63c553dd16ec5343",
            "lastReadAt": "2025-09-24T03:21:01.000Z"
          }
        ],
        "restricted": true,
        "createdAt": "2025-09-23T17:40:36.332Z",
        "updatedAt": "2025-09-24T03:21:01.326Z",
        "lastMessage": {
          "_id": "68d2dd85044130d0b9a9f309",
          "user": "68914287e4c3076d9436523c",
          "chat": "68d2db946da2eec7efd20576",
          "content": "Hi There",
          "at": "2025-09-23T17:48:53.000Z"
        }
      },
      "at": "2025-09-24T03:19:39.000Z",
      "dismissed": true
    },
  ],
  "count": 4
}
```

# 🔒 POST `/notifications/:id/read`

## Description

- Marks a notification as read of that user

# 🔒 POST `/notifications/read-all`

## Description

- Marks all unread notification as read of that user

# Links

[Goto Home](/docs/index.html)