import { Router } from 'express'
import validations from './validations'
import controllers from './controllers'
import auth from '../../utils/auth'
const router = Router()

router.get('/', validations.getNotifications, auth.authorizeUser, controllers.getNotifications)

router.post('/:id/read', validations.postNotificationRead, auth.authorizeUser, controllers.postNotificationRead)

router.post('/read-all', auth.authorizeUser, controllers.postAllNotificationsRead)

module.exports = router
