import { Request, Response, NextFunction } from 'express'
import { validate } from 'super-easy-validator'

function getNotifications(req: Request, res: Response, next: NextFunction) {
  try {
    const rules = {
      limit: 'optional|string|natural',
      page: 'optional|string|natural',
      unread: 'optional|string|boolean'
    }

    const { errors } = validate(rules, req.query)
    if (errors) {
      return res.status(400).json({ message: errors[0] })
    }

    return next()
  } catch (error) {
    console.log(error)
    return res.status(500).json({ message: 'server error' })
  }
}

function postNotificationRead(req: Request, res: Response, next: NextFunction) {
  try {
    const rules = {
      id: 'mongoid'
    }

    const { errors } = validate(rules as any, req.params)
    if (errors) {
      return res.status(400).json({ message: errors[0] })
    }

    return next()
  } catch (error) {
    console.log(error)
    return res.status(500).json({ message: 'server error' })
  }
}

const validations = {
  getNotifications,
  postNotificationRead
}

export default validations
