import { Request, Response } from 'express'
import { Reel } from '../models'
import { IUser } from '../../users/models'
import { Deletion } from '../../deletions/models'
import reelControllers from '../controllers'

async function deleteReel(req: Request, res: Response) {
	try {
		const id = req.params.id

		const reel = await Reel.findById(id).populate('user')
		if (!reel) {
			return res.status(404).json({ message: 'reel not found' })
		}

		const user = reel.user as unknown as IUser
		await Deletion.create({
			collections: 'reels',
			user: user._id,
			data: reel
		})

		reelControllers.deleteReelAndItsAssets(reel, user, false)

		return res.json({ message: 'reel deleted successfully' })
	} catch (error) {
		console.log(error)
		return res.status(500).json({ message: 'server error' })
	}
}

const controllers = {
	deleteReel
}

export default controllers
