import { Router } from 'express'
import validations from './validations'
import controllers from './controllers'
import auth from '../../utils/auth'
const router = Router()

router.get('/', validations.getReels, auth.authorizeUser, controllers.getReels)

router.get('/explore', validations.getExploreReels, auth.authorizeUser, controllers.getExploreReels)

router.get('/user/:userId', validations.getUserReels, auth.authorizeUser, controllers.getUserReels)

router.get('/:id', validations.checkReelId, auth.authorizeUser, controllers.getReel)

router.post('/presign-url', validations.postPresignUrl, auth.authorizeUser, controllers.postPresignUrl)

router.post('/', validations.postReel, auth.authorizeUser, controllers.postReel)

router.patch('/:id', validations.patchReel, auth.authorizeUser, controllers.patchReel)

router.delete('/:id', validations.checkReelId, auth.authorizeUser, controllers.deleteReel)

module.exports = router
