import { Request, Response } from 'express'
import { IUser } from '../users/models'
import { Report } from './models'
import { Reel } from '../reels/models'

async function postReport(req: Request, res: Response) {
	interface Payload {
		reel: string
		category: string
		message?: string
	}
	try {
		const { reel: reelId, category, message } = req.body as Payload
		const user = res.locals.user as IUser

		const reel = await Reel.findById(reelId)
		if(!reel) {
			return res.status(404).json({message: 'reel not found'})
		}

		await Report.create({
			reportedBy: user._id,
			user: reel.user,
			reel: reel._id,
			category,
			message
		})

		return res.status(201).json({ message: 'reel reported successfully' })
	} catch (error) {
		console.log(error)
		return res.status(500).json({ message: 'server error' })
	}
}

const controllers = {
	postReport
}

export default controllers
