import { Schema, model, Document, Types } from 'mongoose'

const ReportSchema = new Schema(
	{
		reportedBy: {
			type: Types.ObjectId,
      ref: 'User',
			required: true
		},
		user: {
			type: Types.ObjectId,
      ref: 'User',
			required: true
		},
		reel: {
			type: Types.ObjectId,
      ref: 'Reel',
			required: true
		},
		category: {
			type: String,
			required: true
		},
		message: String
	},
	{ versionKey: false, timestamps: true }
)

export interface IReport extends Document {
	_id: Types.ObjectId
	reportedBy: Types.ObjectId
	user: Types.ObjectId
	reel: Types.ObjectId
	category: string
	message?: string
	createdAt: Date
  updatedAt: Date
}

export const Report = model('Report', ReportSchema, 'reports')
