import { Request, Response, NextFunction } from 'express'
import { validate } from 'super-easy-validator'

function postReport(req: Request, res: Response, next: NextFunction) {
	try {
		const rules = {
			reel: 'mongoid',
			category: 'string|min:1|max:40',
			message: 'optional|string|min:10|max:500',
		}

		const { errors } = validate(rules, req.body)
		if (errors) {
			return res.status(400).json({ message: errors[0] })
		}

		if(req.body.category.toLowerCase() === 'other' && !req.body.message) {
			return res.status(400).json({ message: 'message is required in case of other category' })
		}

		return next()
	} catch (error) {
		console.log(error)
		return res.status(500).json({ message: 'server error' })
	}
}

const validations = {
	postReport
}

export default validations
