import { Schema, model, Document, Types } from 'mongoose'

const RequestSchema = new Schema(
	{
		user: {
			type: Types.ObjectId,
			ref: 'User',
			required: true,
		},
		chat: {
			type: Types.ObjectId,
			ref: 'Chat',
			required: true
		},
		status: {
			type: String,
			enum: ['pending', 'accepted', 'rejected'],
			default: 'pending',
		},
		createdAt: {
			type: Date,
			default: Date
		},
		acceptedAt: Date,
		rejectedAt: Date,
	},
	{ versionKey: false }
)

export interface IRequest extends Document {
	_id: Types.ObjectId
	user: Types.ObjectId
	chat: Types.ObjectId
	status: 'pending' | 'accepted' | 'rejected'
	createdAt: Date
	acceptedAt?: Date
	rejectedAt?: Date
}

export const Request = model('Request', RequestSchema, 'requests')
