import { Router } from 'express'
import validations from './validations'
import controllers from './controllers'
import auth from '../../utils/auth'
const router = Router()

router.get('/', validations.getRequests, auth.authorizeUser, controllers.getRequests)

router.get('/:id', validations.getRequest, auth.authorizeUser, controllers.getRequest)

router.post('/', validations.postRequest, auth.authorizeUser, controllers.postRequest)

router.patch('/:id', validations.patchRequest, auth.authorizeUser, controllers.patchRequest)

module.exports = router
