import { Schema, model, Document, Types } from 'mongoose'

const RewardHashSchema = new Schema(
	{
		user: {
			type: Types.ObjectId,
			required: true,
			ref: 'User'
		},
		reward: {
			type: Types.ObjectId,
			ref: 'Reward'
		},
		hash: {
			type: String,
			required: true
		},
		isConsumed: Boolean,
		isMeetme: Boolean,
		score: {
			type: Types.ObjectId,
			ref: 'Score'
		},
		at: {
			type: Date,
			default: Date,
		}
	},
	{ versionKey: false }
)

export interface IRewardHash extends Document {
	_id: Types.ObjectId
	user: Types.ObjectId
	reward?: Types.ObjectId
	hash: string
	isConsumed?: boolean
	isMeetme?: Boolean
	score?: Types.ObjectId
	at: Date
}

export const RewardHash = model('RewardHash', RewardHashSchema, 'reward-hashes')
