[Goto Home](/docs/index.html)

# 🔐 GET `/admin/rewards`

## Request Query

- **limit** - default `10`; set the number of items to return on each page
- **page** - default `1`; set the page for which to return the items
- **search** - add search filter; searches from `title` and `description`
- **isMeetme** - sets `isMeetme` filter; if `true` only returns rewards where `isMeetme` = `true`; if `false` only returns profile rewards; if `undefined`, return all rewards
- **isActive** - if `true`, only returns those rewards which are not expired and has remaining count greater than 0

## Description

- Returns rewards as per pagination

## Response Body

```json
{
  "rewards": [
    {
      "_id": "690ca0269c211309c3fe73fa",
      "title": "Nike",
      "description": "Get a discount of upto 5% on Nike Shoes",
      "total": 200,
      "remaining": 200,
      "cover": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/rewards/690ca0269c211309c3fe73fa/1762435110368-44631916485328615-nike.jpg",
      "createdAt": "2025-11-06T13:18:31.607Z",
      "updatedAt": "2025-11-06T13:18:31.607Z"
    },
    {
      "_id": "6901c4d485fe9d12a0b3e26c",
      "title": "Apple",
      "description": "Get a discount of upto 5% on iPhone 16 Pro",
      "total": 80,
      "remaining": 80,
      "location": {
        "type": "Point",
        "coordinates": [
          -34.566,
          12.455
        ]
      },
      "locationString": "Central Park, Rock-port, UK",
      "cover": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/rewards/6901c4d485fe9d12a0b3e26c/1761723604119-6661274652227103-apple.jpg",
      "createdAt": "2025-10-29T07:40:05.005Z",
      "updatedAt": "2025-10-29T07:40:05.005Z",
      "isMeetme": true
    },
    {
      "_id": "6901c49585fe9d12a0b3e269",
      "title": "Amazon",
      "description": "Get a discount of upto 20% with a max of USD 7",
      "total": 300,
      "remaining": 300,
      "location": {
        "type": "Point",
        "coordinates": [
          -34.566,
          12.455
        ]
      },
      "locationString": "Central Park, Rock-port, UK",
      "cover": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/rewards/6901c49585fe9d12a0b3e269/1761723540790-28613655510605573-amazon.png",
      "createdAt": "2025-10-29T07:39:01.617Z",
      "updatedAt": "2025-10-29T07:39:01.617Z",
      "isMeetme": true
    },
    {
      "_id": "6901c43885fe9d12a0b3e263",
      "title": "Adidas",
      "description": "Get a discount of USD 23 with an order of minimum USD 200",
      "total": 100,
      "remaining": 100,
      "location": {
        "type": "Point",
        "coordinates": [
          -34.566,
          12.455
        ]
      },
      "locationString": "Central Park, Rock-port, UK",
      "cover": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/rewards/6901c43885fe9d12a0b3e263/1761723447917-8775154287889242-adidas.png",
      "createdAt": "2025-10-29T07:37:29.357Z",
      "updatedAt": "2025-10-29T07:37:29.357Z",
      "isMeetme": true
    },
    {
      "_id": "69007c68ed57fd48466ed0ea",
      "title": "Starbucks",
      "description": "Get one free on any latte, when you check in with vibe",
      "total": 500,
      "remaining": 489,
      "location": {
        "type": "Point",
        "coordinates": [
          -34.566,
          12.455
        ]
      },
      "locationString": "Central Park, Rock-port, UK",
      "cover": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/rewards/69007c68ed57fd48466ed0ea/1761639525912-6152251467462092-starbucks.webp",
      "createdAt": "2025-10-28T08:18:50.603Z",
      "updatedAt": "2025-11-11T10:31:47.213Z",
      "coupon": "AK6OFF"
    }
  ],
  "count": 5
}
```

# 🔐 GET `/admin/rewards/:id`

## Description

- Returns the specific reward details

## Response Body

```json
{
  "reward": {
    "_id": "690ca0269c211309c3fe73fa",
    "title": "Nike",
    "description": "Get a discount of upto 5% on Nike Shoes",
    "total": 200,
    "remaining": 200,
    "cover": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/rewards/690ca0269c211309c3fe73fa/1762435110368-44631916485328615-nike.jpg",
    "createdAt": "2025-11-06T13:18:31.607Z",
    "updatedAt": "2025-11-06T13:18:31.607Z"
  }
}
```

# 🔐 POST `/admin/rewards`

## Description

- Adds a new reward
- Location is optional

## Request Body (Form Data)

```json
{
  "title": "Starbucks",
  "description": "Get one free on any latte, when you check in with vibe",
  "latitude?": "12.55",
  "longitude?": "12.55",
  "locationString?": "US",
  "total": "10",
  "isMeetme": "true",
  "coupon": "BHI034699",
  "expiredAt": "2025-11-12T13:51:03.925Z",
  "cover": ImageFile
}
```

## Response Body

```json
{
  "reward": {
    "title": "Starbucks",
    "description": "Get one free on any latte, when you check in with vibe",
    "total": 10,
    "remaining": 10,
    "isMeetme": true,
    "location": {
      "type": "Point",
      "coordinates": [
        -34.566,
        12.455
      ]
    },
    "locationString": "Central Park, Rock-port, UK",
    "_id": "69007c68ed57fd48466ed0ea",
    "cover": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/rewards/69007c68ed57fd48466ed0ea/1761639525912-6152251467462092-starbucks.webp",
    "createdAt": "2025-10-28T08:18:50.603Z",
    "updatedAt": "2025-10-28T08:18:50.603Z"
  }
}
```

# 🔐 DELETE `/admin/rewards/:id`

## Description

- Deletes the reward and its cover image

# Links

[Goto Home](/docs/index.html)
